/******************************************************************************
*  This file is to Initialize the entire RF4CE Nwk.
*
* (c) Copyright 2008, Freescale, Inc. All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
******************************************************************************/

#include "EmbeddedTypes.h"
#include "MsgSystem.h"
#include "PlatformInit.h"
#include "IrqControlLib.h"
#include "Crt0.h"
#include "PortConfig.h"
#include "NVM_Interface.h"
#include "TMR_Interface.h"
#include "PowerManager.h"
#include "NwkInit.h"
#include "NwkGlobals.h"
#include "TS_Interface.h"
#include "AppAspInterface.h"
#include "UART_Interface.h"

/******************************************************************************
*******************************************************************************
* Private macros
*******************************************************************************
******************************************************************************/
/* Number of elements in an array. */
#define NumberOfElements(array)   ((sizeof(array) / (sizeof(array[0]))))

/******************************************************************************
*******************************************************************************
* Private prototypes
*******************************************************************************
******************************************************************************/

void NwkTaskInit(void);
void TS_PlaceHolderTaskInit(void);

/******************************************************************************
*******************************************************************************
* Private type definitions
*******************************************************************************
******************************************************************************/

typedef struct beeTaskEntry_tag {
  tsTaskID_t *pTaskID;
  void (*pInitFunction)(void);
  void (*pEventHandler)(event_t);
  tsTaskPriority_t priority;
} beeTaskEntry_t;

/******************************************************************************
*******************************************************************************
* Private memory declarations
*******************************************************************************
******************************************************************************/

#define Task(taskIdGlobal, taskInitFunc, taskMainFunc, priority) \
  { &taskIdGlobal, taskInitFunc, taskMainFunc, priority },

beeTaskEntry_t const beeTaskTable[] = {
#include "NwkTasksTbl.h"
};

/******************************************************************************
*******************************************************************************
* Public functions
*******************************************************************************
******************************************************************************/

void NwkInit(void) {
  /* Initialize the non volatile memory handling module */
  NvModuleInit();
  /* Create the Nwk task */
  NwkTaskInit();
}

/******************************************************************************
*******************************************************************************
* Private functions
*******************************************************************************
******************************************************************************/

/* This function can be used in the table in NwkTasksTbl.h for any task */
/* that does not have it's own init function. */
void TS_PlaceHolderTaskInit(void) {
}

/*****************************************************************************/

/* Init the Nwk tasks. Add all of them to the kernel's task table, and */
/* call of the init functions. */
void NwkTaskInit(void) {
  index_t i;

  /* Add the tasks to the kernel's task table first. That way, if any of the */
  /* init functions want to set events, all of the task ids will be defined. */
  for (i = 0; i < NumberOfElements(beeTaskTable); ++i) {
    *beeTaskTable[i].pTaskID = TS_CreateTask(beeTaskTable[i].priority,
                                             beeTaskTable[i].pEventHandler);
  }

  for (i = 0; i < NumberOfElements(beeTaskTable); ++i) {
    (*beeTaskTable[i].pInitFunction)();
  }
}                                       /* NwkTaskInit() */
